var sourceDir = '.';

var gulp = require('gulp');

var merge = require('merge-stream');
var rename = require('gulp-rename');
var uglify = require('gulp-uglify');


// Combine JS and minify
gulp.task('scripts', function minifyScripts() {
  var assets = [
    {
      src: sourceDir + '/node_modules/jquery-sticky/jquery.sticky.js',
      dest: sourceDir + '/views/templates/wizard/javascript',
      name: 'jquery.sticky.min.js'
    }
  ];

  var mergeStreams = merge();

  for (var i in assets) {
    mergeStreams.add(
      gulp.src(assets[i].src)
      .pipe(rename(assets[i].name))
      .pipe(uglify())
      .pipe(gulp.dest(assets[i].dest))
    );
  }

  return mergeStreams;
});

// Build assets
gulp.task('build', gulp.series('scripts'));
